<?php
/**
 * Пример использования TRD Merger
 * Демонстрирует склейку файлов внутри TRD образа
 */

require_once 'public/include/helpers/trd_merger.php';

// Пример 1: Склейка всех файлов страниц в один
function mergeAllPages($trdPath) {
    $filesToMerge = [
        ['name' => '0.C', 'start' => 0x6000],
        ['name' => '1.C', 'start' => 0xC000],
        ['name' => '3.C', 'start' => 0xC000],
        ['name' => '4.C', 'start' => 0xC000],
        ['name' => '6.C', 'start' => 0xC000],
        ['name' => '7.C', 'start' => 0xC000]
    ];
    
    $result = TRDMerger::mergeFiles($trdPath, $filesToMerge, 'all_pages.C', 0x6000);
    
    if ($result) {
        echo "✓ Все страницы склеены в all_pages.C\n";
        
        // Удаляем исходные файлы
        $filesToRemove = ['0.C', '1.C', '3.C', '4.C', '6.C', '7.C'];
        TRDMerger::removeFiles($trdPath, $filesToRemove);
        echo "✓ Исходные файлы удалены\n";
    } else {
        echo "✗ Ошибка склейки файлов\n";
    }
}

// Пример 2: Склейка только определенных страниц
function mergeSpecificPages($trdPath) {
    $filesToMerge = [
        ['name' => '0.C', 'start' => 0x6000],
        ['name' => '1.C', 'start' => 0xC000]
    ];
    
    $result = TRDMerger::mergeFiles($trdPath, $filesToMerge, 'main_pages.C', 0x6000);
    
    if ($result) {
        echo "✓ Основные страницы склеены в main_pages.C\n";
    } else {
        echo "✗ Ошибка склейки основных страниц\n";
    }
}

// Пример 3: Склейка с сохранением исходных файлов
function mergeKeepOriginal($trdPath) {
    $filesToMerge = [
        ['name' => '6.C', 'start' => 0xC000],
        ['name' => '7.C', 'start' => 0xC000]
    ];
    
    $result = TRDMerger::mergeFiles($trdPath, $filesToMerge, 'extra_pages.C', 0xC000);
    
    if ($result) {
        echo "✓ Дополнительные страницы склеены в extra_pages.C (исходные сохранены)\n";
    } else {
        echo "✗ Ошибка склейки дополнительных страниц\n";
    }
}

// Использование
if (isset($argv[1]) && file_exists($argv[1])) {
    $trdFile = $argv[1];
    echo "Обработка TRD файла: $trdFile\n\n";
    
    // Создаем резервную копию
    copy($trdFile, $trdFile . '.backup');
    echo "✓ Создана резервная копия\n\n";
    
    // Примеры склейки
    mergeAllPages($trdFile);
    echo "\n";
    
    // Восстанавливаем из резервной копии для следующего примера
    copy($trdFile . '.backup', $trdFile);
    mergeSpecificPages($trdFile);
    echo "\n";
    
    // Восстанавливаем из резервной копии для следующего примера
    copy($trdFile . '.backup', $trdFile);
    mergeKeepOriginal($trdFile);
    
    echo "\n✓ Обработка завершена\n";
} else {
    echo "Использование: php trd_merge_example.php <путь_к_trd_файлу>\n";
    echo "Пример: php trd_merge_example.php zapil.trd\n";
}
?>
