<?php
NFW::i()->registerResource('jquery.activeForm');

$speeds = array(
    array('value' => 0, 'desc' => 'Take from GIF'),
    array('value' => 1, 'desc' => '1 - fastest'),
    2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 15, 20, 30, 40, 50, 75, 100, 125, 150, 200, 255
);
?>
<style>
    .form-group.disabled {
        opacity: 0.6;
        pointer-events: none;
    }
    .form-group.disabled input {
        background-color: #f5f5f5;
        cursor: not-allowed;
    }
    .text-muted {
        color: #999 !important;
    }
</style>
<script type="text/javascript">
    $(document).ready(function () {
        const downloadResultBtn = $('button[id="download-result"]');
        const resultLog = $('div[id="result-log"]');
        let autoScroll = true;
        function isNearBottom(el) {
            const threshold = 20;
            return el.scrollTop + el.clientHeight >= el.scrollHeight - threshold;
        }
        resultLog.on('scroll', function () { autoScroll = isNearBottom(this); });
        resultLog.on('mousedown touchstart', function () { autoScroll = false; });
        resultLog.on('mouseup mouseleave touchend', function () { autoScroll = isNearBottom(this); });

        // console.log('Setting up activeForm...');
        try {
            $('form[id="demo-maker"]').activeForm({
                'error': function (response) {
                    handleResponse(response);
                },
                'success': function (response) {
                    handleResponse(response);
                },
                'beforeSubmit': function () {
                    // Принудительно добавляем trd_merge_enabled в форму
                    var checkbox = $('input[name="trd_merge_enabled"]');

                    // Всегда добавляем trd_merge_enabled в форму
                    var value = checkbox.is(':checked') ? '1' : '0';

                    // Удаляем старые скрытые поля
                    $('input[name="trd_merge_enabled"][type="hidden"]').remove();

                    // Добавляем новое скрытое поле
                    $('<input>').attr({
                        type: 'hidden',
                        name: 'trd_merge_enabled',
                        value: value
                    }).appendTo($('#demo-maker'));

                    resultLog.html('<div>Loading data...</div>');
                    downloadResultBtn.attr('disabled', 'disabled');
                    $('button[id="close-dialog"]').attr('disabled', 'disabled');
                    $('div[id="result-dialog"]').modal('show');
                }
            });
        } catch (e) {
            // console.error('Error setting up activeForm:', e);
        }

        function handleResponse(response) {
            if (response.result === 'error') {
                resultLog.append('<div class="text-error">' + response["last_msg"] + '</div>');
                $('button[id="close-dialog"]').removeAttr('disabled');
                return;
            } else if (response.result === 'done') {
                // Append success messages
                $.each(response.log, function (i, text) {
                    resultLog.append('<div>' + text + '</div>');
                });
                if (autoScroll && resultLog[0]) {
                    resultLog.scrollTop(resultLog[0].scrollHeight);
                }

                $('button[id="close-dialog"]').removeAttr('disabled');
                downloadResultBtn.removeAttr('disabled').attr('href', response.download);
                return;
            }

            // Append log
            $.each(response.log, function (i, text) {
                $('div[id="result-log"]').append('<div>' + text + '</div>');
            });
            if (autoScroll && resultLog[0]) {
                resultLog.scrollTop(resultLog[0].scrollHeight);
            }

            // Do next stage
            $.post(null, response, function (next_response) {
                handleResponse(next_response);
            }, 'json');
        }

        downloadResultBtn.click(function () {
            window.location.href = $(this).attr('href');
        });



        // Обработчик изменения типа анализатора
        function updateAnalyzerType(analyzerId) {
            var analyzerType = $('#' + analyzerId + 'Type').val();
            var hintElement = $('#' + analyzerId + 'Sens').closest('.form-group').find('.hint');
            
            switch(analyzerType) {
                case 'bright':
                    hintElement.text('Using FLASH-color in Background image for analyzer area');
                    break;
                case 'border':
                    hintElement.text('Border color will change with music');
                    break;
                case 'ink':
                    hintElement.text('Using FLASH-color in Background image for analyzer area');
                    break;
                case 'pixel':
                    hintElement.text('Pixel will appear/disappear with music');
                    break;
            }
        }



        // Обработчики изменения типа анализатора
        $('#mainAnalyzerType').change(function() {
            updateAnalyzerType('mainAnalyzer');
        });
        
        $('#splashAnalyzerType').change(function() {
            updateAnalyzerType('splashAnalyzer');
        });

        // Функция управления полями музыки (взаимное исключение)
        window.updateMusicField = function() {
            var musicbankFile = $('#musicbank_zip')[0].files.length > 0;
            var musicFile = $('#musicFile');
            var musicFileSelected = musicFile[0].files.length > 0;
            
            if (musicbankFile) {
                // Если выбран musicbank, блокируем поле для отдельного файла музыки
                musicFile.prop('disabled', true);
                musicFile.closest('.form-group').addClass('disabled');
                musicFile.closest('.form-group').find('label').addClass('text-muted');
                // Очищаем поле музыки при выборе musicbank
                musicFile.val('');
            } else if (musicFileSelected) {
                // Если выбран отдельный файл музыки, блокируем поле musicbank
                $('#musicbank_zip').prop('disabled', true);
                $('#musicbank_zip').closest('.form-group').addClass('disabled');
                $('#musicbank_zip').closest('.form-group').find('label').addClass('text-muted');
                // Очищаем поле musicbank при выборе отдельного файла
                $('#musicbank_zip').val('');
            } else {
                // Если ничего не выбрано, разблокируем оба поля
                musicFile.prop('disabled', false);
                musicFile.closest('.form-group').removeClass('disabled');
                musicFile.closest('.form-group').find('label').removeClass('text-muted');
                
                $('#musicbank_zip').prop('disabled', false);
                $('#musicbank_zip').closest('.form-group').removeClass('disabled');
                $('#musicbank_zip').closest('.form-group').find('label').removeClass('text-muted');
            }
        }

        // Обработчики изменения файлов музыки
        $('#musicbank_zip').change(function() {
            updateMusicField();
        });
        
        $('#musicFile').change(function() {
            updateMusicField();
        });
        
        // Дополнительная проверка для полей файлов
        $('#musicbank_zip, #musicFile').on('click', function() {
            var $this = $(this);
            // Сохраняем текущее значение
            $this.data('lastValue', $this.val());
        }).on('change input', function() {
            var $this = $(this);
            var currentValue = $this.val();
            var lastValue = $this.data('lastValue');
            
            // Если поле пустое, но было значение - значит нажали отмену
            if (!currentValue && lastValue) {
                $this.val(''); // Принудительно очищаем
                updateMusicField();
            }
        });
        


        // Инициализация при загрузке страницы
        updateAnalyzerType('mainAnalyzer');
        updateAnalyzerType('splashAnalyzer');
        updateMusicField();
        

        
        // Обработчик выбора пользовательского шрифта
        $('input[name="scroll_font"]').change(function() {
            var selectedFont = $(this).val();
            if (selectedFont === 'custom') {
                $('#custom_font_upload').show();
            } else {
                $('#custom_font_upload').hide();
                // Сбрасываем превью при выборе другого шрифта
                var scrollType = $('input[name="scroll_type"]:checked').val();
                resetCustomFontPreview(scrollType);
            }
        });
        

        
        // Предварительный просмотр загруженного изображения
        $('#customFontPreview').change(function() {
            var file = this.files[0];
            if (file) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    var scrollType = $('input[name="scroll_type"]:checked').val();
                    if (scrollType === '16') {
                        $('#customFont16PreviewImg').attr('src', e.target.result);
                        $('#customFont16PreviewImg').show();
                        $('#customFont16Placeholder').hide();
                        // console.log('16x16 font preview loaded');
                    } else {
                        $('#customFontPreviewImg').attr('src', e.target.result);
                        $('#customFontPreviewImg').show();
                        $('#customFontPlaceholder').hide();
                        // console.log('8x8 font preview loaded');
                    }
                };
                reader.readAsDataURL(file);
            }
        });
        
        // Принудительно устанавливаем правильные размеры для изображений шрифтов
        function fixFontImageSizes() {
            $('img[src*="font"]').each(function() {
                var img = $(this);
                var src = img.attr('src');
                
                // Убираем все ограничения размера для отображения в оригинальном размере
                img.css({
                    'max-width': 'none',
                    'width': 'auto',
                    'height': 'auto',
                    'image-rendering': 'pixelated'
                });
            });
        }
        
        // Вызываем функцию после загрузки страницы
        $(window).on('load', function() {
            setTimeout(fixFontImageSizes, 100);
        });
        
        // Также вызываем при переключении шрифтов
        $('input[name="scroll_type"]').change(function() {
            setTimeout(fixFontImageSizes, 100);
        });
    });
</script>

<style>
    FORM#demo-maker .form-group-margin {
        margin-bottom: 10px;
    }

    FORM#demo-maker LABEL.hint {
        font-weight: normal;
    }

    DIV#result-log {
        font-family: monospace;
        font-size: 85%;
        white-space: pre-wrap;
        height: 256px;
        max-height: 256px;
        overflow: scroll;
    }

    /* Стили для изображений шрифтов - отображаем в оригинальном размере */
    FORM#demo-maker .radio-inline img[src*="font"],
    FORM#demo-maker img[src*="font1.png"],
    FORM#demo-maker img[src*="font2.png"],
    FORM#demo-maker img[src*="font3.png"],
    FORM#demo-maker img[src*="font8.png"] {
        max-width: none !important;
        width: auto !important;
        height: auto !important;
        display: inline-block !important;
    }
    
    /* Переопределяем Bootstrap правила для изображений шрифтов */
    FORM#demo-maker .radio-inline img[src*="font1.png"] {
        max-width: none !important;
        width: auto !important;
        height: auto !important;
        image-rendering: pixelated !important;
    }
    
    FORM#demo-maker .radio-inline img[src*="font2.png"] {
        max-width: none !important;
        width: auto !important;
        height: auto !important;
        image-rendering: pixelated !important;
    }
    
    FORM#demo-maker .radio-inline img[src*="font3.png"] {
        max-width: none !important;
        width: auto !important;
        height: auto !important;
        image-rendering: pixelated !important;
    }
    
    FORM#demo-maker .radio-inline img[src*="font8.png"] {
        max-width: 273px !important;
        width: 273px !important;
        height: 183px !important;
        image-rendering: pixelated !important;
    }
    
    /* Стили для пользовательского шрифта */
    #customFontPreviewImg,
    #customFont16PreviewImg {
        image-rendering: pixelated !important;
    }
    
    /* Специальные стили для 16x16 шрифтов */
    #customFont16PreviewContainer {
        width: auto !important;
        height: auto !important;
        min-width: 160px;
        min-height: 32px;
    }
</style>

<div id="result-dialog" class="modal fade">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header"><h4 class="modal-title">Result</h4></div>
            <div id="content" class="modal-body">
                <div id="result-log"></div>
            </div>
            <div class="modal-footer">
                <button id="download-result" class="btn btn-primary" disabled="disabled">Download</button>
                <button id="close-dialog" type="button" class="btn btn-default" data-dismiss="modal"
                        disabled="disabled">Close
                </button>
            </div>
        </div>
    </div>
</div>

<form id="demo-maker" class="form-horizontal" action="?action=make" enctype="multipart/form-data">
    <input type="hidden" name="MAX_FILE_SIZE" value="16777216"/>
    <fieldset>
        <legend>Main setup</legend>
        <div class="form-group form-group-margin">
            <label for="musicFile" class="col-md-3 control-label">PT2/PT3 music</label>
            <div class="col-md-9">
                <input id="musicFile" type="file" name="music_file"/>
                <button type="button" class="btn btn-default btn-sm" style="margin-top: 5px;" onclick="window.clearMusicFile()">Clear</button>
            </div>
        </div>

        <div class="form-group form-group-margin">
            <label for="splashBackground" class="col-md-3 control-label">Splash file</label>
            <div class="col-md-9">
                <input id="splashBackground" type="file" name="splash_background"/>
                <button type="button" class="btn btn-default btn-sm" style="margin-top: 5px;" onclick="window.clearSplashBackground()">Clear</button>
            </div>
        </div>

        <div class="form-group form-group-margin" id="border">
            <label for="splashBorder" class="col-md-3 control-label">Border</label>
            <div class="col-md-2">
                <select id="splashBorder" name="splash_border" class="form-control">
                    <option value="0" style="background-color: #000000;">black</option>
                    <option value="1" style="background-color: #0000cc;">blue</option>
                    <option value="2" style="background-color: #cc0000;">red</option>
                    <option value="3" style="background-color: #cc00cc;">magenta</option>
                    <option value="4" style="background-color: #00cc00;">green</option>
                    <option value="5" style="background-color: #00cccc;">cyan</option>
                    <option value="6" style="background-color: #cccc00;">yellow</option>
                    <option value="7" style="background-color: #cccccc;">white</option>
                </select>
            </div>
        </div>

        <div class="form-group form-group-margin">
            <label for="splashDelay" class="col-md-3 control-label">Splash delay</label>
            <div class="col-md-2">
                <select id="splashDelay" name="splash_delay" class="form-control">
                    <option value="1">1 pattern</option>
                    <option value="2">2 patterns</option>
                    <option value="3">3 patterns</option>
                    <option value="4">4 patterns</option>
                    <option value="5">5 patterns</option>
                </select>
            </div>
        </div>


    </fieldset>

    <fieldset>
        <legend>Background setup</legend>

        <div class="form-group form-group-margin">
            <label for="mainBackground" class="col-md-3 control-label">Background</label>
            <div class="col-md-9">
                <input id="mainBackground" type="file" name="main_background"/>
                <button type="button" class="btn btn-default btn-sm" style="margin-top: 5px;" onclick="window.clearMainBackground()">Clear</button>
            </div>
        </div>

        <div class="form-group form-group-margin">
            <label for="mainBorder" class="col-md-3 control-label">Animation Border</label>
            <div class="col-md-2">
                <select id="mainBorder" name="main_border" class="form-control">
                    <option value="0" style="background-color: #000000;">black</option>
                    <option value="1" style="background-color: #0000cc;">blue</option>
                    <option value="2" style="background-color: #cc0000;">red</option>
                    <option value="3" style="background-color: #cc00cc;">magenta</option>
                    <option value="4" style="background-color: #00cc00;">green</option>
                    <option value="5" style="background-color: #00cccc;">cyan</option>
                    <option value="6" style="background-color: #cccc00;">yellow</option>
                    <option value="7" style="background-color: #cccccc;">white</option>
                </select>
            </div>
        </div>

        <div class="form-group form-group-margin">
            <label for="mainInk" class="col-md-3 control-label">INK</label>
            <div class="col-md-2">
                <select id="mainInk" name="main_ink" class="form-control">
                    <option value="0" style="background-color: #000000;">black</option>
                    <option value="1" style="background-color: #0000cc;">blue</option>
                    <option value="2" style="background-color: #cc0000;">red</option>
                    <option value="3" style="background-color: #cc00cc;">magenta</option>
                    <option value="4" style="background-color: #00cc00;">green</option>
                    <option value="5" style="background-color: #00cccc;">cyan</option>
                    <option value="6" style="background-color: #cccc00;">yellow</option>
                    <option value="7" style="background-color: #cccccc;" selected="selected">white</option>
                </select>
            </div>
            <label for="mainPaper" class="col-md-1 control-label">PAPER</label>
            <div class="col-md-2">
                <select id="mainPaper" name="main_paper" class="form-control">
                    <option value="0" style="background-color: #000000;">black</option>
                    <option value="1" style="background-color: #0000cc;">blue</option>
                    <option value="2" style="background-color: #cc0000;">red</option>
                    <option value="3" style="background-color: #cc00cc;">magenta</option>
                    <option value="4" style="background-color: #00cc00;">green</option>
                    <option value="5" style="background-color: #00cccc;">cyan</option>
                    <option value="6" style="background-color: #cccc00;">yellow</option>
                    <option value="7" style="background-color: #cccccc;">white</option>
                </select>
            </div>
            <div class="col-md-2">
                <label class="checkbox-inline">
                    <input type="hidden" name="main_bright" value="0"/>
                    <input type="checkbox" name="main_bright" value="1" checked="checked"/> BRIGHT
                </label>
            </div>
        </div>

        <div class="form-group form-group-margin">
            <label for="mainAnalyzerEnabled" class="col-md-3 control-label">Analyzer</label>
            <div class="col-md-2">
                <select id="mainAnalyzerEnabled" name="main_analyzer_enabled" class="form-control">
                    <option value="0">disabled</option>
                    <option value="1" selected="selected">enabled</option>
                </select>
            </div>
            <div class="col-md-2">
                <select id="mainAnalyzerType" name="main_analyzer_type" class="form-control">
                    <option value="goba_left">Goba Left</option>
                    <option value="goba_right">Goba Right</option>
                    <option value="goba_up">Goba Up</option>
                    <option value="goba_down">Goba Down</option>
                </select>
            </div>
            <div class="col-md-3">
                <label class="hint">
                    Goba analyzer for main screen
                </label>
            </div>
        </div>
        
        <!-- Goba analyzer coordinates -->
        <div class="form-group form-group-margin" id="mainGobaCoords" style="display: none;">
            <label class="col-md-3 control-label">Position (X,Y)</label>
            <div class="col-md-2">
                <input type="number" id="mainAnalyzerX" name="main_analyzer_x" class="form-control" 
                       min="1" max="32" value="1" placeholder="X (1-32)"/>
            </div>
            <div class="col-md-2">
                <input type="number" id="mainAnalyzerY" name="main_analyzer_y" class="form-control" 
                       min="1" max="24" value="1" placeholder="Y (1-24)"/>
            </div>
            <div class="col-md-3">
                <label class="hint">
                    Coordinates for Goba analyzer position
                </label>
            </div>
        </div>
    </fieldset>

    <fieldset>
        <legend>Animation 1 (main/slow)</legend>
        <div class="form-group">
            <label for="animation1" class="col-md-3 control-label">GIF/ZIP file</label>
            <div class="col-md-9">
                <input id="animation1" type="file" name="animation1"/>
                <button type="button" class="btn btn-default btn-sm" style="margin-top: 5px;" onclick="window.clearAnimation1()">Clear</button>
                <span class="help-block"></span>
            </div>
        </div>

        <div class="form-group form-group-margin">
            <label for="speed1" class="col-md-3 control-label">Speed</label>
            <div class="col-md-3">
                <select id="speed1" name="speed1" class="form-control">
                    <?php foreach ($speeds as $s) {
                        if (is_array($s)) {
                            echo '<option value="' . $s['value'] . '">' . $s['desc'] . '</option>';
                        } else {
                            echo '<option value="' . $s . '">' . $s . '</option>';
                        }
                    } ?>
                </select>
            </div>
        </div>
    </fieldset>

    <fieldset>
        <legend>Animation 2 (int/slow)</legend>
        <div class="form-group">
            <label for="animation2" class="col-md-3 control-label">GIF/ZIP file</label>
            <div class="col-md-9">
                <input id="animation2" type="file" name="animation2"/>
                <button type="button" class="btn btn-default btn-sm" style="margin-top: 5px;" onclick="window.clearAnimation2()">Clear</button>
                <span class="help-block"></span>
            </div>
        </div>

        <div class="form-group form-group-margin">
            <label for="speed2" class="col-md-3 control-label">Speed</label>
            <div class="col-md-3">
                <select id="speed2" name="speed2" class="form-control">
                    <?php foreach ($speeds as $s) {
                        if (is_array($s)) {
                            echo '<option value="' . $s['value'] . '">' . $s['desc'] . '</option>';
                        } else {
                            echo '<option value="' . $s . '">' . $s . '</option>';
                        }
                    } ?>
                </select>
            </div>
        </div>
    </fieldset>

    <fieldset>
        <legend>Animation 3 (int/fast)</legend>
        <div class="form-group">
            <label for="animation3" class="col-md-3 control-label">GIF/ZIP file</label>
            <div class="col-md-9">
                <input id="animation3" type="file" name="animation3"/>
                <button type="button" class="btn btn-default btn-sm" style="margin-top: 5px;" onclick="window.clearAnimation3()">Clear</button>
                <span class="help-block"></span>
            </div>
        </div>

        <div class="form-group form-group-margin">
            <label for="speed3" class="col-md-3 control-label">Speed</label>
            <div class="col-md-3">
                <select id="speed3" name="speed3" class="form-control">
                    <?php foreach ($speeds as $s) {
                        if (is_array($s)) {
                            echo '<option value="' . $s['value'] . '">' . $s['desc'] . '</option>';
                        } else {
                            echo '<option value="' . $s . '">' . $s . '</option>';
                        }
                    } ?>
                </select>
            </div>
        </div>
        <div class="form-group form-group-margin">
            <label for="animation3_method" class="col-md-3 control-label">Method</label>
            <div class="col-md-3">
                <select id="animation3_method" name="animation3_method" class="form-control">
                    <option value="fast">fast (обычный)</option>
                    <option value="memsave">slow (медленный)</option>
                </select>
            </div>
        </div>
    </fieldset>

    <fieldset>
        <legend>Animation 4 (int/fast)</legend>
        <div class="form-group">
            <label for="animation4" class="col-md-3 control-label">GIF/ZIP file</label>
            <div class="col-md-9">
                <input id="animation4" type="file" name="animation4"/>
                <button type="button" class="btn btn-default btn-sm" style="margin-top: 5px;" onclick="window.clearAnimation4()">Clear</button>
                <span class="help-block"></span>
            </div>
        </div>

        <div class="form-group form-group-margin">
            <label for="speed4" class="col-md-3 control-label">Speed</label>
            <div class="col-md-3">
                <select id="speed4" name="speed4" class="form-control">
                    <?php foreach ($speeds as $s) {
                        if (is_array($s)) {
                            echo '<option value="' . $s['value'] . '">' . $s['desc'] . '</option>';
                        } else {
                            echo '<option value="' . $s . '">' . $s . '</option>';
                        }
                    } ?>
                </select>
            </div>
        </div>
        <div class="form-group form-group-margin">
            <label for="animation4_method" class="col-md-3 control-label">Method</label>
            <div class="col-md-3">
                <select id="animation4_method" name="animation4_method" class="form-control">
                    <option value="fast">fast (обычный)</option>
                    <option value="memsave">slow (медленный)</option>
                </select>
            </div>
        </div>
    </fieldset>

    <fieldset>
        <legend>SlideShow (ZIP of compressed images)</legend>
        <div class="form-group form-group-margin">
            <label for="slideshow_zip" class="col-md-3 control-label">ZIP archive</label>
            <div class="col-md-9">
                <input id="slideshow_zip" type="file" name="slideshow_zip" accept=".zip" />
                <button type="button" class="btn btn-default btn-sm" style="margin-top: 5px;" onclick="window.clearSlideshow()">Clear</button>
                <span class="help-block">Upload a ZIP archive with compressed images for SlideShow. Supported banks: 0,1,3,4,6,7.</span>
            </div>
        </div>
    </fieldset>

    <fieldset>
        <legend>MusicBank (ZIP of PT2/PT3 files)</legend>
        <div class="form-group form-group-margin">
            <label for="musicbank_zip" class="col-md-3 control-label">ZIP archive</label>
            <div class="col-md-9">
                <input id="musicbank_zip" type="file" name="musicbank_zip" accept=".zip"/>
                <button type="button" class="btn btn-default btn-sm" style="margin-top: 5px;" onclick="window.clearMusicbank()">Clear</button>
                <span class="help-block">Upload a ZIP archive with PT2/PT3 music files for MusicBank. Maximum 10 files. Supported banks: 0,1,3,4,6,7.</span>
            </div>
        </div>
    </fieldset>

    <fieldset>
        <legend>Scroll setup</legend>
        <div class="form-group form-group-margin">
            <label for="scrollText" class="col-md-3 control-label">Text</label>
            <div class="col-md-9">
                <textarea id="scrollText" name="scroll_text" class="form-control" rows="7"></textarea>
            </div>
        </div>

        <div class="form-group form-group-margin">
            <label class="col-md-3 control-label">Scroll type</label>
            <div class="col-md-9">
                <label class="radio-inline">
                    <input type="radio" checked name="scroll_type" value="16" id="scroll_type_16"/>
                    16px height
                </label>
                <label class="radio-inline">
                    <input type="radio" name="scroll_type" value="8" id="scroll_type_8"/>
                    8px height
                </label>
            </div>
        </div>

        <div class="form-group form-group-margin" id="scroll_direction_group" style="display: none;">
            <label class="col-md-3 control-label">Scroll direction</label>
            <div class="col-md-9">
                <label class="radio-inline">
                    <input type="radio" checked name="scroll_direction" value="left" id="scroll_direction_left"/>
                    Left
                </label>
                <label class="radio-inline">
                    <input type="radio" name="scroll_direction" value="up" id="scroll_direction_up"/>
                    Up
                </label>
            </div>
        </div>

        <div class="form-group form-group-margin" id="scroll_coords_group" style="display: none;">
            <label class="col-md-3 control-label">Coordinates</label>
            <div class="col-md-9">
                <div class="row">
                    <div class="col-md-4">
                        <label for="scroll_coord_x">X (0-31)</label>
                        <input type="number" id="scroll_coord_x" name="scroll_coord_x" class="form-control" min="0" max="31" value="16"/>
                    </div>
                    <div class="col-md-4">
                        <label for="scroll_coord_y">Y (0-22)</label>
                        <input type="number" id="scroll_coord_y" name="scroll_coord_y" class="form-control" min="0" max="22" value="4"/>
                    </div>
                    <div class="col-md-4">
                        <label for="scroll_visota">Height (1-24)</label>
                        <input type="number" id="scroll_visota" name="scroll_visota" class="form-control" min="1" max="24" value="8"/>
                    </div>
                </div>
            </div>
        </div>

        <div class="form-group form-group-margin">
            <label class="col-md-3 control-label">Scroll font</label>
            <div class="col-md-9">
                <div id="fonts_16px">
                <label class="radio-inline">
                    <input type="radio" checked name="scroll_font" value="1"/>
                    <img src="<?php echo NFW::i()->base_path ?>resources/font1.png" alt=""/>
                </label>
                <label class="radio-inline">
                    <input type="radio" name="scroll_font" value="2"/>
                    <img src="<?php echo NFW::i()->base_path ?>resources/font2.png" alt=""/>
                </label>
                <label class="radio-inline">
                    <input type="radio" name="scroll_font" value="3"/>
                    <img src="<?php echo NFW::i()->base_path ?>resources/font3.png" alt=""/>
                </label>
                <label class="radio-inline">
                    <input type="radio" name="scroll_font" value="custom"/>
                    <div id="customFont16PreviewContainer" style="display: inline-block; border: 2px dashed #ccc; text-align: center; color: #999; position: relative; font-size: 12px; padding: 8px;">
                        <span id="customFont16Placeholder">Custom</span>
                        <img id="customFont16PreviewImg" src="" alt="Custom font preview" style="display: none; max-width: none; width: auto; height: auto; object-fit: contain; position: relative;"/>
                    </div>
                </label>
                </div>
                <div id="fonts_8px" style="display: none;">
                    <label class="radio-inline">
                        <input type="radio" name="scroll_font" value="8"/>
                        <img src="<?php echo NFW::i()->base_path ?>resources/font8.png" alt="8x8"/>
                    </label>
                    <label class="radio-inline">
                        <input type="radio" name="scroll_font" value="custom"/>
                        <div id="customFontPreviewContainer" style="display: inline-block; width: 273px; height: 183px; border: 2px dashed #ccc; text-align: center; line-height: 183px; color: #999; position: relative;">
                            <span id="customFontPlaceholder">Custom font</span>
                            <img id="customFontPreviewImg" src="" alt="Custom font preview" style="display: none; width: 100%; height: 100%; object-fit: contain; position: absolute; top: 0; left: 0;"/>
                        </div>
                    </label>
                </div>
                
                <div id="custom_font_upload" style="display: none; margin-top: 10px;">
                    <div class="form-group">
                        <label for="customFontFile" class="col-md-3 control-label">Custom font file</label>
                        <div class="col-md-9">
                            <input id="customFontFile" type="file" name="custom_font_file" accept=".bin,.dat,.fnt"/>
                            <button type="button" class="btn btn-default btn-sm" style="margin-top: 5px;" onclick="window.clearCustomFontFile()">Clear</button>
                            <span class="help-block">Upload your font file (binary format)</span>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="customFontPreview" class="col-md-3 control-label">Font preview image</label>
                        <div class="col-md-9">
                            <input id="customFontPreview" type="file" name="custom_font_preview" accept=".png,.jpg,.jpeg,.gif"/>
                            <button type="button" class="btn btn-default btn-sm" style="margin-top: 5px;" onclick="window.clearCustomFontPreview()">Clear</button>
                            <span class="help-block">Upload preview image (PNG, JPG, GIF)</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="form-group form-group-margin">
            <label for="scrollInk" class="col-md-3 control-label">INK</label>
            <div class="col-md-2">
                <select id="scrollInk" name="scroll_ink" class="form-control">
                    <option value="0" style="background-color: #000000;">black</option>
                    <option value="1" style="background-color: #0000cc;">blue</option>
                    <option value="2" style="background-color: #cc0000;">red</option>
                    <option value="3" style="background-color: #cc00cc;">magenta</option>
                    <option value="4" style="background-color: #00cc00;">green</option>
                    <option value="5" style="background-color: #00cccc;">cyan</option>
                    <option value="6" style="background-color: #cccc00;" selected="selected">yellow</option>
                    <option value="7" style="background-color: #cccccc;">white</option>
                </select>
            </div>
            <label for="scrollPaper" class="col-md-1 control-label">PAPER</label>
            <div class="col-md-2">
                <select id="scrollPaper" name="scroll_paper" class="form-control">
                    <option value="0" style="background-color: #000000;">black</option>
                    <option value="1" style="background-color: #0000cc;">blue</option>
                    <option value="2" style="background-color: #cc0000;">red</option>
                    <option value="3" style="background-color: #cc00cc;">magenta</option>
                    <option value="4" style="background-color: #00cc00;">green</option>
                    <option value="5" style="background-color: #00cccc;">cyan</option>
                    <option value="6" style="background-color: #cccc00;">yellow</option>
                    <option value="7" style="background-color: #cccccc;">white</option>
                </select>
            </div>
            <div class="col-md-2">
                <label class="checkbox-inline">
                    <input type="hidden" name="scroll_bright" value="0"/>
                    <input type="checkbox" name="scroll_bright" value="1" checked="checked"/> BRIGHT
                </label>
            </div>
        </div>

        <div class="form-group form-group-margin" id="scroll_width_group">
            <label for="scrollWidth" class="col-md-3 control-label">Scroll width</label>
            <div class="col-md-3">
                <input type="number" id="scrollWidth" name="scroll_width" class="form-control" value="32" min="1" max="32" step="1"/>
                <span class="help-block">Number of characters (1-32, default: 32)</span>
            </div>
        </div>

        <div class="form-group form-group-margin" id="scroll_offset_group">
            <label for="scrollOffset" class="col-md-3 control-label">Horizontal offset</label>
            <div class="col-md-3">
                <input type="number" id="scrollOffset" name="scroll_offset" class="form-control" value="0" min="0" max="31" step="1"/>
                <span class="help-block">Offset from right edge (0=right edge, 31=left edge)</span>
            </div>
        </div>

        <div class="form-group form-group-margin" id="scroll_position_group">
            <label for="scrollPosition" class="col-md-3 control-label">Position</label>
            <div class="col-md-3">
                <select id="scrollPosition" name="scroll_position" class="form-control">
                    <option value="#401f|#5800">01</option>
                    <option value="#403f|#5820">02</option>
                    <option value="#405f|#5840">03</option>
                    <option value="#407f|#5860">04</option>
                    <option value="#409f|#5880">05</option>
                    <option value="#40bf|#58a0">06</option>
                    <option value="#40de|#58c0">07</option>
                    <option value="#40ff|#58e0">08</option>

                    <option value="#481f|#5900">09</option>
                    <option value="#483f|#5920">10</option>
                    <option value="#485f|#5940">11</option>
                    <option value="#487f|#5960">12</option>
                    <option value="#489f|#5980">13</option>
                    <option value="#48bf|#59a0">14</option>
                    <option value="#48df|#59c0">15</option>
                    <option value="#48ff|#59e0">16</option>

                    <option value="#501f|#5a00">17</option>
                    <option value="#503f|#5a20">18</option>
                    <option value="#505f|#5a40">19</option>
                    <option value="#507f|#5a60">20</option>
                    <option value="#509f|#5a80">21</option>
                    <option value="#50bf|#5aa0">22</option>
                    <option value="#50df|#5ac0">23</option>
					<option value="#50ff|#5ae0">24</option>
                </select>
            </div>
        </div>
        <br/>
        <div class="form-group form-group-margin">
            <div class="col-md-offset-3 col-md-9">
                <label class="checkbox-inline">
                    <input type="checkbox" name="trd_merge_enabled" value="1" checked="checked"/> 
                    <strong>Создать моноблок</strong> (объединить все файлы в boot.B)
                </label>
                <span class="help-block">Объединяет boot.B, splash.C и все страницы данных в один файл</span>
            </div>
        </div>
        
        <div class="form-group form-group-margin">
            <div class="col-md-offset-3 col-md-9">
                <label class="checkbox-inline">
                    <input type="hidden" name="int_counter_enabled" value="0"/>
                    <input type="checkbox" name="int_counter_enabled" value="1"/> 
                    <strong>Счетчик прерываний</strong> (добавить переменную int_counter)
                </label>
                <span class="help-block">Добавляет переменную int_counter для подсчета прерываний</span>
            </div>
        </div>

        <div class="form-group">
            <div class="col-md-offset-3 col-md-9">
                <button type="submit" class="btn btn-primary btn-lg">Create</button>
            </div>
        </div>
    </fieldset>
</form>

<!-- Временный тест JavaScript -->
<script>
// alert('Test JavaScript loaded!');
// console.log('Test JavaScript loaded!');
</script>

<script>
// alert('JavaScript loaded!');
// console.log('JavaScript loaded!');
$(document).ready(function() {
    // console.log('Document ready!');
    
    // Функция для сброса превью пользовательского шрифта
    function resetCustomFontPreview(scrollType) {
        if (scrollType === '16') {
            $('#customFont16PreviewImg').hide();
            $('#customFont16Placeholder').show();
            $('#customFont16PreviewImg').attr('src', '');
        } else {
            $('#customFontPreviewImg').hide();
            $('#customFontPlaceholder').show();
            $('#customFontPreviewImg').attr('src', '');
        }
        $('#customFontPreview').val('');
    }
    
    // Функция для показа/скрытия полей координат
    function toggleGobaCoords(analyzerEnabled, analyzerType, coordsId) {
        if (analyzerEnabled == '1' && (analyzerType === 'goba_left' || analyzerType === 'goba_right' || analyzerType === 'goba_up' || analyzerType === 'goba_down')) {
            $('#' + coordsId).show();
        } else {
            $('#' + coordsId).hide();
        }
    }
    
    // Обработчик для main анализатора
    $('#mainAnalyzerEnabled, #mainAnalyzerType').change(function() {
        toggleGobaCoords($('#mainAnalyzerEnabled').val(), $('#mainAnalyzerType').val(), 'mainGobaCoords');
    });
    
    // Инициализация при загрузке страницы
    toggleGobaCoords($('#mainAnalyzerEnabled').val(), $('#mainAnalyzerType').val(), 'mainGobaCoords');
    
    // Принудительно добавляем trd_merge_enabled в форму при отправке
    $('#demo-maker').submit(function() {
        var checkbox = $('input[name="trd_merge_enabled"]');
        
        if (checkbox.is(':checked')) {
            // Убеждаемся, что значение отправляется
        } else {
            // Если не отмечен, добавляем скрытое поле с value="0"
            $('<input>').attr({
                type: 'hidden',
                name: 'trd_merge_enabled',
                value: '0'
            }).appendTo($(this));
        }
    });
    
    // console.log('Setting up activeForm...');
    try {
        $('form[id="demo-maker"]').activeForm({
            'error': function (response) {
                handleResponse(response);
            },
            'success': function (response) {
                handleResponse(response);
            },
            'beforeSubmit': function () {
                // Принудительно добавляем trd_merge_enabled в форму
                var checkbox = $('input[name="trd_merge_enabled"]');

                // Всегда добавляем trd_merge_enabled в форму
                var value = checkbox.is(':checked') ? '1' : '0';

                // Удаляем старые скрытые поля
                $('input[name="trd_merge_enabled"][type="hidden"]').remove();

                // Добавляем новое скрытое поле
                $('<input>').attr({
                    type: 'hidden',
                    name: 'trd_merge_enabled',
                    value: value
                }).appendTo($('#demo-maker'));
                
                // Определяем все необходимые переменные
                var resultLog = $('div[id="result-log"]');
                var downloadResultBtn = $('button[id="download-result"]');
                
                resultLog.html('<div>Loading data...</div>');
                downloadResultBtn.attr('disabled', 'disabled');
                $('button[id="close-dialog"]').attr('disabled', 'disabled');
                $('div[id="result-dialog"]').modal('show');
            }
        });
    } catch (e) {
        // console.error('Error setting up activeForm:', e);
    }
    
    // Определяем autoScroll если он не существует
    if (typeof autoScroll === 'undefined') {
        var autoScroll = true;
    }
    
    function handleResponse(response) {
        // Определяем все необходимые переменные
        var resultLog = $('div[id="result-log"]');
        var downloadResultBtn = $('button[id="download-result"]');
        
        if (response.result === 'error') {
            resultLog.append('<div class="text-error">' + response["last_msg"] + '</div>');
            $('button[id="close-dialog"]').removeAttr('disabled');
            return;
        } else if (response.result === 'done') {
            // Append success messages
            $.each(response.log, function (i, text) {
                resultLog.append('<div>' + text + '</div>');
            });
            if (autoScroll && resultLog[0]) {
                resultLog.scrollTop(resultLog[0].scrollHeight);
            }

            $('button[id="close-dialog"]').removeAttr('disabled');
            downloadResultBtn.removeAttr('disabled').attr('href', response.download);
            return;
        }

        // Append log
        $.each(response.log, function (i, text) {
            resultLog.append('<div>' + text + '</div>');
        });
        if (autoScroll && resultLog[0]) {
            resultLog.scrollTop(resultLog[0].scrollHeight);
        }

        // Do next stage - прокидываем trd_merge_enabled вперед, если он был в ответе
        if (typeof response.trd_merge_enabled !== 'undefined') {
            response.trd_merge_enabled = response.trd_merge_enabled;
        } else {
            var chk = $('input[name="trd_merge_enabled"]');
            if (chk.length) {
                response.trd_merge_enabled = chk.is(':checked') ? '1' : '0';
            }
        }

        $.post(null, response, function (next_response) {
            handleResponse(next_response);
        }, 'json');
    }

    // Определяем downloadResultBtn если он не существует
    if (typeof downloadResultBtn === 'undefined') {
        var downloadResultBtn = $('button[id="download-result"]');
    }
    
    downloadResultBtn.click(function () {
        window.location.href = $(this).attr('href');
    });

    // Переключение шрифтов в зависимости от типа бегущей строки
    function updateFonts() {
        var scrollType = $('input[name="scroll_type"]:checked').val();
        
        if (scrollType == '8') {
            $('#fonts_16px').hide();
            $('#fonts_8px').show();
            // Показываем группу направления скролла для 8px
            $('#scroll_direction_group').show();
            // Автоматически выбираем шрифт 8x8
            $('input[name="scroll_font"][value="8"]').prop('checked', true);
            $('#custom_font_upload').hide();
            resetCustomFontPreview('8');
            // Для 8px разрешаем все позиции (включая 24)
            $('#scrollPosition option').show();
        } else {
            $('#fonts_8px').hide();
            $('#fonts_16px').show();
            // Скрываем группу направления скролла для 16px
            $('#scroll_direction_group').hide();
            $('#custom_font_upload').hide();
            // Автоматически выбираем шрифт 1
            $('input[name="scroll_font"][value="1"]').prop('checked', true);
            resetCustomFontPreview('16');
            // Для 16px ограничиваем позиции до 23
            $('#scrollPosition option').each(function() {
                var optionText = $(this).text();
                if (optionText === '24') {
                    $(this).hide();
                } else {
                    $(this).show();
                }
            });
            // Если выбрана позиция 24, переключаем на позицию 23
            if ($('#scrollPosition option:selected').text() === '24') {
                $('#scrollPosition option[value="#50df|#5ac0"]').prop('selected', true);
            }
        }
    }

    // Обработчик изменения типа анализатора
    function updateAnalyzerType(analyzerId) {
        var analyzerType = $('#' + analyzerId + 'Type').val();
        var hintElement = $('#' + analyzerId + 'Sens').closest('.form-group').find('.hint');
        
        switch(analyzerType) {
            case 'bright':
                hintElement.text('Brightness threshold (0-255)');
                break;
            case 'contrast':
                hintElement.text('Contrast threshold (0-255)');
                break;
            case 'goba_left':
            case 'goba_right':
            case 'goba_up':
            case 'goba_down':
                hintElement.text('GOBA threshold (0-255)');
                break;
            default:
                hintElement.text('Threshold (0-255)');
        }
    }
    
    // Инициализация при загрузке страницы
    updateFonts();
    updateAnalyzerType('main');
    updateAnalyzerType('splash');
    
    // Обработчики событий
    $('input[name="scroll_type"]').change(updateFonts);
    $('input[name="scroll_direction"]').change(function() {
        var direction = $(this).val();
        if (direction == 'up') {
            $('#scroll_coords_group').show();
            // Делаем неактивными старые параметры скролла
            $('#scroll_width_group input').prop('disabled', true);
            $('#scroll_offset_group input').prop('disabled', true);
            $('#scroll_position_group select').prop('disabled', true);
        } else {
            $('#scroll_coords_group').hide();
            // Делаем активными старые параметры скролла
            $('#scroll_width_group input').prop('disabled', false);
            $('#scroll_offset_group input').prop('disabled', false);
            $('#scroll_position_group select').prop('disabled', false);
        }
    });
    $('#mainAnalyzerType').change(function() { updateAnalyzerType('main'); });
    $('#splashAnalyzerType').change(function() { updateAnalyzerType('splash'); });
    
    // Дополнительная проверка для Firefox
    $('#slideshow_zip').on('focusout blur', function() {
        var $this = $(this);
        setTimeout(function() {
            if (!$this.val()) {
                // Поле пустое - можно добавить дополнительную логику
            }
        }, 100);
    });
    
    });
</script>

<script type="text/javascript">

// Функции очистки полей музыки
window.clearMusicFile = function() {
    $('#musicFile').val('');
    window.updateMusicField();
};

window.clearMusicbank = function() {
    $('#musicbank_zip').val('');
    window.updateMusicField();
};

// Функция очистки поля slideshow
window.clearSlideshow = function() {
    $('#slideshow_zip').val('');
};

// Функции очистки для всех остальных полей
window.clearSplashBackground = function() {
    $('#splashBackground').val('');
};

window.clearMainBackground = function() {
    $('#mainBackground').val('');
};

window.clearAnimation1 = function() {
    $('#animation1').val('');
};

window.clearAnimation2 = function() {
    var field = document.getElementById('animation2');
    if (field) {
        field.value = '';
    }
};

window.clearAnimation3 = function() {
    $('#animation3').val('');
};

window.clearAnimation4 = function() {
    $('#animation4').val('');
};

window.clearCustomFontFile = function() {
    $('#customFontFile').val('');
};

window.clearCustomFontPreview = function() {
    $('#customFontPreview').val('');
};
</script>