# Руководство по созданию собственных анализаторов

## Обзор

Анализаторы в Zapilyator - это эффекты аудио-визуализации, которые реагируют на музыку с AY-чипа ZX Spectrum. Они читают данные с каналов A, B или C и изменяют экран в зависимости от громкости.

## Структура анализатора

### XML файл анализатора

Анализатор определяется в файле `public/resources/output/snippets/analyzer_*.xml`:

```xml
<snippet>
    <name>Analyzer name</name>
    <description>Description of analyzer</description>
    <template><![CDATA[
        ; Assembly code here
    ]]></template>
    <length>68</length>
    <params>
        <param>
            <varname>CHANNEL</varname>
            <type>byte</type>
            <default>#0a</default>
        </param>
        <param>
            <varname>SENS</varname>
            <type>byte</type>
            <default>#0f</default>
        </param>
        <!-- Дополнительные параметры -->
    </params>
</snippet>
```

### Обязательные параметры

- **CHANNEL** - канал AY-чипа (8=A, 9=B, 10=C)
- **SENS** - чувствительность (8-15)

### Стандартный код чтения AY

```assembly
ld bc,#fffd : ld a, %CHANNEL% : out (c),a : in a,(c)
CUR_AY	ld e,#00
cp e : jr nc, $+4
ld a,e : dec a
ld (CUR_AY + 1), a		
cp %SENS% : jr c, 1f
```

## Примеры анализаторов

### 1. Analyzer Bright (существующий)

Изменяет яркость пикселей в зависимости от громкости.

**Параметры:**
- CHANNEL - канал AY
- SENS - чувствительность  
- DATA - список адресов экрана

**Эффект:** Пиксели становятся ярче при громких звуках.

### 2. Analyzer Border (новый)

Изменяет цвет бордера в зависимости от громкости.

**Параметры:**
- CHANNEL - канал AY
- SENS - чувствительность
- BRIGHT_COLOR - цвет при громком звуке
- DARK_COLOR - цвет при тихом звуке

**Эффект:** Бордер меняет цвет в такт музыке.

### 3. Analyzer Ink (новый)

Изменяет цвет INK в зависимости от громкости.

**Параметры:**
- CHANNEL - канал AY
- SENS - чувствительность
- BRIGHT_INK - цвет INK при громком звуке
- DARK_INK - цвет INK при тихом звуке
- DATA - список адресов атрибутов

**Эффект:** Цвет текста/графики меняется в такт музыке.

### 4. Analyzer Pixel (новый)

Рисует/стирает пиксели в зависимости от громкости.

**Параметры:**
- CHANNEL - канал AY
- SENS - чувствительность
- PIXEL_ADDR - адрес пикселя
- PIXEL_MASK - маска для рисования
- PIXEL_MASK_INV - маска для стирания

**Эффект:** Пиксели появляются/исчезают в такт музыке.

## Как добавить свой анализатор

### Шаг 1: Создать XML файл

Создайте файл `public/resources/output/snippets/analyzer_yourname.xml`:

```xml
<snippet>
    <name>Your Analyzer</name>
    <description>Your analyzer description</description>
    <template><![CDATA[
        ; Ваш assembly код
        ld bc,#fffd : ld a, %CHANNEL% : out (c),a : in a,(c)
        ; ... ваш код ...
    ]]></template>
    <length>25</length>
    <params>
        <param>
            <varname>CHANNEL</varname>
            <type>byte</type>
            <default>#0a</default>
        </param>
        <param>
            <varname>SENS</varname>
            <type>byte</type>
            <default>#0f</default>
        </param>
        <!-- Ваши параметры -->
    </params>
</snippet>
```

### Шаг 2: Добавить поддержку в код (опционально)

Если нужно добавить специальную логику в PHP код, отредактируйте `public/include/modules/zapilyator.php`.

### Шаг 3: Добавить в интерфейс (опционально)

Если нужно добавить настройки в веб-интерфейс, отредактируйте `public/include/templates/zapilyator.tpl`.

## Советы по созданию

1. **Используйте стандартный код чтения AY** для получения данных
2. **Сравнивайте с SENS** для определения громкости
3. **Используйте условные переходы** для разных состояний
4. **Учитывайте размер кода** в параметре `<length>`
5. **Тестируйте на реальном ZX Spectrum**

## Примеры эффектов

- **Цветовые эффекты:** изменение INK, PAPER, BRIGHT
- **Графические эффекты:** рисование/стирание пикселей
- **Анимация:** перемещение объектов
- **Звуковые эффекты:** изменение частот, эффектов
- **Специальные эффекты:** скроллинг, мерцание

## Отладка

1. Проверьте синтаксис assembly кода
2. Убедитесь в правильности параметров
3. Протестируйте на эмуляторе
4. Проверьте размер выделенной памяти 